// js/returnScroll.js
(() => {
  const KEY = 'scrollToPosition';

  function save(y) {
    try { sessionStorage.setItem(KEY, String(Math.max(0, Math.floor(y)))); } catch {}
  }
  function saveCurrent() {
    save(window.scrollY || document.documentElement.scrollTop || 0);
  }
  function restore() {
    const pos = sessionStorage.getItem(KEY);
    if (!pos) return;

    if (pos === 'nav') {
      const nav = document.querySelector('.navigation-container');
      if (nav) nav.scrollIntoView({ behavior: 'auto', block: 'center' });
    } else {
      const y = parseInt(pos, 10);
      if (!Number.isNaN(y)) window.scrollTo({ top: y, left: 0, behavior: 'auto' });
    }
    sessionStorage.removeItem(KEY);
  }
  function bind() {
    // Пометь любые ссылки как data-remember-scroll или .remember-scroll
    document.querySelectorAll('[data-remember-scroll], .remember-scroll, #cta-startup')
      .forEach(el => el.addEventListener('click', saveCurrent));
  }

  // Восстановить позицию после инициализации пинов/анимаций
  window.addEventListener('load', () => setTimeout(restore, 150));
  document.addEventListener('DOMContentLoaded', bind);

  // Фолбэк для кнопок «Назад» на test/* (не перезаписывает точный scrollY)
  window.saveScrollFallbackToNav = function () {
    if (!sessionStorage.getItem(KEY)) {
      try { sessionStorage.setItem(KEY, 'nav'); } catch {}
    }
  };
})();
