/* Slides Tree v1d1 by M@rkdel@ngelo */
/*
    let clientId = 'UniqueClientKey'; //i.e 'Default2023' or 'MySlides'
    let navMenu = 'navbarMenuID';
    let slidesBackgroundsOpacity = 0.35; // Custom opacity for slides background
    let slidesTree = {
        'class-link-0d0-0d0': 'slide0d0', // Default slide
        'class-link-0d0-1d1': 'slide1d1', // Slide 0.0 (Default) to Slide 1.1
        'class-link-1d1-1d2': 'slide1d2',
        'class-link-1d2-1d1': 'slide1d1', //back link from Slide 1.2 to Slide 1.1
        '...': '...', // etc.
    }
*/

if (typeof slidesBackgroundsOpacity === 'undefined') {
    slidesBackgroundsOpacity = 0.5;
}

if (typeof slidesTree === 'undefined') {
    //default slide 1.1
    slidesTree = { 'slide-0d0-0d1': 'slide1d1', };
}

let menu = (typeof navMenu !== 'undefined')? 
    $('#' + navMenu) : 
    $('#navbarMenu');

let slidesIDs = [];
let headerHeight = $('#home').outerHeight();
let slideUp   = { top: '-100vh', opacity: 0.25 }
let slideDown = { top: '200vh', opacity: 0.25 }
let visibleSlideStyles = { 
    display: 'flex', 
    'z-index': 2, 
    opacity: 0.25, 
    top: 0, height: '100vh', 
    'padding-top': headerHeight, 
}
let defaultDuration = 700;
let defaultDirection = 'forward';
let defaultId = () => {
    return slidesTree[Object.keys(slidesTree).shift()];
}
let slideBackgroundId = 0;

const currentIdKey = () => {
    if (typeof clientId === 'undefined') {
        clientId = 'default';
    }
    return 'currentId-' + clientId;
}

const currentId = () => {
    let cId = sessionStorage.getItem(currentIdKey());
    return (null != cId)? cId: defaultId();
}

const slideTo = (showId, slideDir) => {
    if (slidesIDs.includes(showId)) {
        upDirection = ('forward' == slideDir);
        slidesIDs.forEach(element => {
            if (showId != element) {
                let sl = $("#" + element);
                if ('flex' == sl.css('display')) {
                    var slideAnimation = (upDirection? slideUp: slideDown);
                    sl.css({'z-index': 1}).animate(slideAnimation, defaultDuration, () => {
                        sl.css({ display: 'none' });
                    });
                }
            }
        });

        window.location.hash = showId;

        let show = $("#" + showId);
        show.css(visibleSlideStyles);
        show.scrollTop(0);

        if (showId == currentId()) {
            if (showId == defaultId()) {
                show.animate({opacity: 0.25}, defaultDuration/3).animate({opacity: 1}, defaultDuration/2);
            } else { 
                show.css({opacity: 1});
            }
        } else {
            let styles = { opacity: 0, top: (upDirection? '100vh': '-100vh') };
            let animation = { opacity: 1, top: (upDirection? headerHeight*-1.05: headerHeight*1.05) };
            show.css(styles).animate(animation, defaultDuration/1.25);
            animation = { top: 0 };
            show.css(styles).animate(animation, defaultDuration/4);
        }

        sessionStorage.setItem(currentIdKey(), showId);

        revialFooter(showId);
    }
}

let changeBackground = (slideId) => {
    if (typeof slidesBackgrounds == 'undefined') return;
    let imageUrl = slidesBackgrounds[slideId];
    if (typeof imageUrl == 'undefined') return;
    slideBackgroundId = (1==slideBackgroundId)? 0 : 1;
    let slideBackgroundOffId = (1==slideBackgroundId)? 0 : 1;

    $('#slide-background-'+slideBackgroundOffId).animate({opacity:0}, defaultDuration*2 );
    $('#slide-background-'+slideBackgroundId).css('background-image', 'url(' + imageUrl + ')').animate({opacity:slidesBackgroundsOpacity}, defaultDuration*2 );
}

let togglePreloader = (name) => {

    let preload = $('#'+name);

    if (typeof preload !== 'undefined') {
        $("#preload").animate({opacity: 0}, defaultDuration/2, () => {
            $("#preload").toggle();
            slideTo(currentId(), defaultDirection);
        });
    } else {
        slideTo(currentId(), defaultDirection);
    }
}

const updateHash = () => {
    if (typeof $(window.location.hash) !== 'undefined') {
        let showId = window.location.hash.replace( /^#/, '');
        if (slidesIDs.includes(showId)) {
            sessionStorage.setItem(currentIdKey(), showId);
        }
    }
}

/* Slide's direction */
const sDir = (sId) => {
    let sP = sId.split('-', 3);
    return (sP.length == 3 && sP[1] > sP[2])? 'backward': 'forward';
}

const addListener = (slideId, showId) => {
    $('.' + slideId).on('click', (event) => {
        slideTo(showId, sDir(slideId));
        $('#'+ showId +'-fp').html( $('#footer') );
        $('#footer').addClass('active');
        changeBackground(showId);
        event.preventDefault();
    });
}

const addScrollListener = (slideId) => {
    $('#' + slideId).on('scroll', () => {
        revialFooter( slideId );
    });
}


let Initilize = () => {
    try {
        $.each(slidesTree, (key) => {
            if (typeof menu !== 'undefined') {
                $('.' + key).on('click', (event) => {
                    if (true === menu.hasClass('show')) {
                        menu.removeClass('show');
                        event.preventDefault();
                    }
                });
            }

            let slideId = slidesTree[key];
            addListener(key, slideId);
            addScrollListener(slideId);
            if (!slidesIDs.includes(slideId)) {
                slidesIDs.push(slideId);
            }
        });
    }

    catch(err) {
        return false;
    }

    return true;
}

let revialFooter = (slideId) => {

    let footer = $('#footer');

    let sl     = $('#' + slideId);
    let slfp   = $('#' + slideId + '-fp');
    let slc    = $('#' + slideId +' .content');
    let slft   = '<div class="containet-fluid slide-ft">&nbsp;</div>';

    if (slc.outerHeight() > $(window).height()) {
        $('#' + slideId).css('align-items', 'start');
    }

    if ('flex' == sl.css('display')) {
        slfp.html(footer);
        slfp.append(slft);
        footer.addClass('active');
        // sl.position({
        //     my:        "left top",
        //     at:        "left bottom",
        //     of:        sl,
        //     collision: "fit"
        // });
    }
}

$(function() {

    if (Initilize()) {
        let slideId = currentId();
        updateHash();
        togglePreloader('preload');
        changeBackground(slideId);
    }
});