/** Calculate Slides total price */
let slidesSteps = {};

let defaultSlideId = '';

const totalPrice = (slideId) => {

    let steps = getPriceSteps(slideId);

    let price = 0;

    $.each(steps, (idx, key) => {
        if (slidesSteps[slideId][key] > 0) {
            price += slidesPrices[slideId][key];
        }
    });

    return price;
}

const getPriceSteps = (slideId) => {
    return Object.keys(slidesPrices[slideId]);
}

const getPrices = (slideId) => {
    return Object.values(slidesPrices[slideId]);
}

const resetPriceSteps = (slideId) => {

    let steps = getPriceSteps(slideId);


    $.each(steps, (idx, key) => {
        if ('indefined' === slidesSteps[slideId]) {
            slidesSteps[slideId] = [];
        }
        slidesSteps[slideId][key] = 0;
        $('#'+slideId+' .'+key).removeClass('active');
    });

    $('#'+slideId+' .totalPrice').text( totalPrice(slideId) );


    stateSave({});
}

const addPriceListeners = (slideId) => {

    let steps = getPriceSteps(slideId);

    if (steps.length > 0) {
        steps.forEach((key) => {

            $('.'+slideId+'-'+ key).on('click', (event) => {
                let total = totalPrice(slideId)
                slidesSteps[slideId][key] = 1;
                $('#'+slideId+' .'+key).addClass('active');
                $('#'+slideId+' .totalPrice').text( total );

                if (totalPrice(slideId) > 0) {

                    if ('slide6d7' === slideId && total > 12000) {
                        let firstHalf = total - 12000;
                        $('#slide6d7-fh').html(firstHalf);
                    }

                    $('.'+slideId+'-Total').css('display', 'inline-block');
                }

                stateSave({'slideId': slideId, 'steps': slidesSteps});
                event.preventDefault();
            });

            let removeKey = key.replace('addStep', 'removeStep');

            $('.'+slideId+'-'+removeKey).on('click', (event) => {

                slidesSteps[slideId][key] = 0;
                $('#'+slideId+' .'+key).removeClass('active');
                $('#'+slideId+' .totalPrice').text( totalPrice(slideId) );

                if (totalPrice(slideId) == 0) {
                    $('.'+slideId+'-Total').css('display', 'none');
                }

                stateSave({'slideId': slideId, 'steps': slidesSteps});
                event.preventDefault();
            });

        });

        $('.'+slideId+'-resetSteps').on('click', (event) => {
            resetPriceSteps(slideId);
            stateSave({'slideId': slideId, 'steps': slidesSteps});
            event.preventDefault();
        });

    }
}

let stateSave = (state) => {
    sessionStorage.setItem(currentIdKey()+'-state', JSON.stringify(state));
}

let stateLoad = () => {
    return sessionStorage.getItem(currentIdKey()+'-state');
}

let stateRestore = (state) => {

    let st = JSON.parse(state);
    let slideId = (typeof st.slideId !== 'undefined')? st.slideId: defaultSlideId;
    if (typeof st.steps !== 'undefined') {
        slidesSteps = st.steps;
    }

    let steps = getPriceSteps(slideId);
    if (steps.length > 0) {
        steps.forEach((key) => {
            $('#'+slideId+' .'+key).removeClass('active').addClass('active');
        });
    }
    $('#'+slideId+' .totalPrice').text( totalPrice(slideId) );

    if (totalPrice(slideId) > 0) {
        $('.'+slideId+'-Total').show();
    }
}

const getSlidesSteps = () => {
    let steps = jQuery.extend(true, {}, slidesPrices);
    $.each( steps, (step) => {
        let st = steps[step];
        $.each (st, (value) => {
            steps[step][value] = 0;
        });
    });
    return steps;
}

window.addEventListener("load", () => {

    slidesSteps = getSlidesSteps();
    //let slidesKeys = Object.keys(slidesSteps)[0];
    defaultSlideId = Object.keys(slidesSteps)[0];

    let prices = Object.keys(slidesPrices);
    if (prices.length > 0) {

        let state = stateLoad();
        if (null !== state) {
            stateRestore(state);
        }

        prices.forEach((slideId) => {
            $('.'+slideId+'-Total').hide();
            addPriceListeners(slideId);
        });
    }

}, false);